%% DeJong/Sphere Function 
% This function is very simple. Any algorithm capable of numeric
% optimization should solve without any problem. Its simplicity helps to
% focus on the effects of dimensionalty in optimization algorithms.
% Major features of the DeJong Function are:
%
% * It is unimodal function
% * Minima : [0, 0, ..., 0]
% * Maxima : 300000
% * Maximum Dimensionality : 30
%% 
% *Function definition* 
%
% $$f(<x_i>) = \sum_{i=1}^n x_i^2$$
%%
% *3D plot*
    clc; clear
    x = -10:10; y = -10:10;
    xy=zeros(length(x)*length(y),2);
    cntpts=0;
    for ii=1:length(x)
        for jj=1:length(y)
            cntpts=cntpts+1;
            xy(cntpts,1:2)=[x(ii),y(jj)];
        end
    end
    funval = DeJong([xy]);
    funval = reshape(funval, length(y),length(x));
    surfc(x, y, funval)
%%
% *Other Useful Functions*
% 
% <DeJong>  <Rosenbrock> <Ackley> <Alpine> <Rastrigin>  <Griewank> <Schaffer>
%